implementation module ostime

import StdInt, StdOverloaded, StdClass
import ostoolbox, intrface, clCrossCall

::	OSTime
	=	OSTime !Int

OSMaxTickCount	:==	2^31-1

OSMaxTime :: OSTime
OSMaxTime = OSTime OSMaxTickCount

OSGetTime :: !*OSToolbox -> (!OSTime,!*OSToolbox)
OSGetTime tb
	# (tickcount,tb)	= GetMessageTime tb
	= (OSTime tickcount,tb)
where
	GetMessageTime :: !*OSToolbox -> (!Int,!*OSToolbox)
	GetMessageTime tb = WinGetTickCount tb

OSWait :: !Int .x !*OSToolbox -> (.x,!*OSToolbox)
OSWait delay x tb
	= (x,WinWait delay tb)

OSGetBlinkInterval :: !*OSToolbox -> (!Int,!*OSToolbox)
OSGetBlinkInterval tb
	= WinGetBlinkTime tb

OSGetCurrentTime :: !*OSToolbox -> (!(!Int,!Int,!Int),!*OSToolbox)
OSGetCurrentTime tb
	= WinGetTime tb

OSGetCurrentDate :: !*OSToolbox -> (!(!Int,!Int,!Int,!Int),!*OSToolbox)
OSGetCurrentDate tb
	= WinGetDate tb

instance - OSTime where
	(-) :: !OSTime !OSTime -> OSTime
	(-) (OSTime new) (OSTime old)
		| old<=new
			= OSTime (new-old)
			= OSTime (OSMaxTickCount-old+new)

instance toInt OSTime where
	toInt :: !OSTime -> Int
	toInt (OSTime t) = t

instance fromInt OSTime where
	fromInt :: !Int -> OSTime
	fromInt t = OSTime (max 0 t)
